-- Database select
USE u213768140_demo;

-- Create products table
CREATE TABLE IF NOT EXISTS products (
  id INT AUTO_INCREMENT PRIMARY KEY,
  title VARCHAR(255) NOT NULL,
  price DECIMAL(10,2) NOT NULL,
  category VARCHAR(100) NOT NULL,
  image TEXT,
  stock INT DEFAULT 0,
  description TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create admins table
CREATE TABLE IF NOT EXISTS admins (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) NOT NULL UNIQUE,
  password VARCHAR(255) NOT NULL
);

-- Insert default admin (username: admin, password: admin123)
INSERT INTO admins (username, password) 
VALUES ('admin', MD5('admin123'))
ON DUPLICATE KEY UPDATE username=username;

-- Insert demo products
INSERT INTO products (title, price, category, image, stock, description) VALUES
('Modern Wooden Sofa (3-seater)', 24999, 'Sofa', 'https://images.unsplash.com/photo-1582585197243-1c6a2f0a7f3c?q=80&w=1200&auto=format&fit=crop', 5, 'Comfortable 3-seater sofa with solid wood frame and textured fabric upholstery.'),
('Classic Dining Table (6 seater)', 17999, 'Dining', 'https://images.unsplash.com/photo-1582587010733-3c0e2a5b9b8d?q=80&w=1200&auto=format&fit=crop', 3, 'Solid teak dining table, hand-finished, perfect for family dinners.'),
('Minimalist Study Desk', 6999, 'Office', 'https://images.unsplash.com/photo-1555041469-a586c61ea9bc?q=80&w=1200&auto=format&fit=crop', 10, 'Slim profile desk with cable management and drawer.'),
('Wooden Bed Frame (King)', 29999, 'Bed', 'https://images.unsplash.com/photo-1600585154340-be6161a56a0c?q=80&w=1200&auto=format&fit=crop', 2, 'Durable king-sized bed frame with slatted base.');
