<?php 
include "header.php"; 
if($_SESSION['usertype'] != "ADMIN2" ){
    ?>
    <script> window.location.href='index.php'; </script>
    <?php
    die;
}
?>

<!-- Commission List Page -->
<style>
    .commission-card{
        border-radius: 16px;
        box-shadow: 0 8px 24px rgba(0,0,0,.08);
        border: 1px solid rgba(0,0,0,.06);
        overflow: hidden;
    }
    .commission-header{
        background: linear-gradient(135deg, #0ea5e9, #22c55e);
        color:#fff;
        padding:24px;
    }
    .commission-header h3{
        margin:0;
        font-weight:700;
        letter-spacing:.3px;
    }
    .table thead th{
        background:#f8fafc;
        font-weight:600;
        border-bottom:1px solid #e5e7eb !important;
    }
    .badge-soft{
        background:#eef2ff;
        color:#3730a3;
        border-radius:999px;
        padding:.35rem .65rem;
        font-size:.85rem;
        font-weight:600;
    }
    .calc-wrap{
        background:#fbfbfb;
        border:1px dashed #e5e7eb;
        border-radius:14px;
        padding:16px;
    }
    .form-control:focus{
        box-shadow:0 0 0 .25rem rgba(14,165,233,.25);
        border-color:#0ea5e9;
    }
    .total-box{
        background:#0ea5e9;
        color:#fff;
        border-radius:12px;
        padding:14px 16px;
        font-weight:700;
    }
</style>

<div class="container my-4">
    <div class="commission-card">
        <div class="commission-header d-flex align-items-center justify-content-between">
            <h3 class="m-0">Commission List</h3>
            </div>

        <div class="p-3 p-md-4">
            <!-- Static Commission Table -->
            <div class="table-responsive mb-3">
                <table class="table align-middle mb-0">
                    <thead>
                        <tr>
                            <th style="width:48px;">#</th>
                            <th>Item</th>
                            <th class="text-end">Commission (per item)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>01</td>
                            <td>Child</td>
                            <td class="text-end fw-semibold">$7</td>
                        </tr>
                        <tr>
                            <td>02</td>
                            <td>Mobile</td>
                            <td class="text-end fw-semibold">$5</td>
                        </tr>
                        <tr>
                            <td>03</td>
                            <td>Address</td>
                            <td class="text-end fw-semibold">$5</td>
                        </tr>
                        <tr>
                            <td>04</td>
                            <td>Name</td>
                            <td class="text-end fw-semibold">$10</td>
                        </tr>
                        <tr>
                            <td>05</td>
                            <td>DOB</td>
                            <td class="text-end fw-semibold">$10</td>
                        </tr>
                    </tbody>
                </table>
            </div>

           <script>
(function(){
    const fmt = v => '$' + (Math.round(v * 100) / 100).toLocaleString();
    const ids = ['child','mobile','name','dob'];

    function recalc(){
        let grand = 0;
        ids.forEach(key=>{
            const el = document.getElementById('q_'+key);
            const qty = Math.max(0, parseInt(el.value || '0', 10));
            const rate = parseFloat(el.dataset.rate || '0');
            const sub = qty * rate;
            document.getElementById('s_'+key).textContent = fmt(sub);
            grand += sub;
        });
        document.getElementById('grand_total').textContent = fmt(grand);
    }

    document.querySelectorAll('.calc-input').forEach(inp=>{
        inp.addEventListener('input', recalc);
        inp.addEventListener('change', recalc);
    });

    recalc();
})();
</script>
