<?php
session_start();
include('../includes/database.php');
include('header.php');

// === Generate Random Txn Reference ===
function GenRandomString() {
    return substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, 10);
}

$paymentStatus = "";
$qr_base64 = "";
$txn_ref_id = "";
$res = null;

if (!$conn) die("DB Error: " . mysqli_connect_error());

// === Generate QR ===
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['amount'])) {
    $txn_ref_id = "dcbirths_birth" . rand(1000000000, 9999999999);
    $upi_id = "paytmqr281005050101pyf8lj0esui1@paytm"; // তোমার UPI ID
    $txnAmount = $_POST['amount'];
    $unitId = "PaytmMerchant";
    $paymentNote = "Wallet Topup";

    $upi_link = "upi://pay?pa={$upi_id}&am={$txnAmount}&pn={$unitId}&tn={$paymentNote}&tr={$txn_ref_id}";
    $qr_url = "https://api.qrserver.com/v1/create-qr-code/?size=400x400&data=" . urlencode($upi_link);
    $qr_image_data = file_get_contents($qr_url);
    $qr_base64 = base64_encode($qr_image_data);

    $_SESSION['txn_ref_id'] = $txn_ref_id;
    $_SESSION['txn_amount'] = $txnAmount;
}

// === Payment Status Check ===
if (isset($_POST['check_status']) && isset($_SESSION['txn_ref_id'])) {
    $txn_ref_id = $_SESSION['txn_ref_id'];
    $amount = $_SESSION['txn_amount'];
    $mid = "tAJJCC07381110220428"; // তোমার Paytm MID

    $JsonData = json_encode(["MID" => $mid, "ORDERID" => $txn_ref_id]);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://securegw.paytm.in/order/status?JsonData=" . urlencode($JsonData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $res = json_decode($response, true);
    $paymentStatus = $res['STATUS'] ?? 'UNKNOWN';

    if ($paymentStatus == 'TXN_SUCCESS') {
        // === Get logged in user's phone number ===
        $username = $_SESSION['phone'];  // phone নম্বর userid হিসেবে save হবে

        $bank_txn_id = $res['BANKTXNID'];
        $order_id = $res['ORDERID'];
        $txn_date = $res['TXNDATE'];
        $purpose = "Paytm UPI";
        $status = 1;
        $type = "CREDIT";

        // === Already exists check ===
        $stmt = mysqli_prepare($conn, "SELECT * FROM wallet WHERE userid = ? AND ORDERID = ?");
        mysqli_stmt_bind_param($stmt, "ss", $username, $txn_ref_id);
        mysqli_stmt_execute($stmt);
        $check_txn_result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($check_txn_result) == 0) {
            // === Update wallet balance ===
            $stmt = mysqli_prepare($conn, "UPDATE usertable SET walletamount = walletamount + ? WHERE phone = ?");
            mysqli_stmt_bind_param($stmt, "ds", $amount, $username);
            mysqli_stmt_execute($stmt);

            // === Get updated balance ===
            $result = mysqli_query($conn, "SELECT walletamount FROM usertable WHERE phone = '$username'");
            $balance = mysqli_fetch_assoc($result)['walletamount'];

            // === Insert into wallet history ===
            $stmt = mysqli_prepare($conn, "INSERT INTO wallet 
                (userid, amount, balance, purpose, status, type, BANKTXNID, ORDERID, paymentStatus, txn_date) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            mysqli_stmt_bind_param(
                $stmt,
                "sdssssssss",
                $username,
                $amount,
                $balance,
                $purpose,
                $status,
                $type,
                $bank_txn_id,
                $order_id,
                $paymentStatus,
                $txn_date
            );
            if (!mysqli_stmt_execute($stmt)) {
                echo "DB Insert Error: " . mysqli_error($conn);
            }
        }

        echo "SUCCESS";
        exit;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Paytm UPI Payment</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body { background:#ffffff; color:#333; font-family:Arial,sans-serif; }
        .center {
            max-width:450px; margin:50px auto; background:#f9f9f9;
            border-radius:10px; padding:30px; text-align:center;
            box-shadow:0 0 20px rgba(0,0,0,0.1);
        }
        select,button { padding:10px; width:100%; font-size:18px; margin-top:10px; }
        .qr-img { border:5px solid #ccc; border-radius:10px; margin-top:20px; }
    </style>
</head>
<body>

<div class="center">
    <h2>ADD BALANCE</h2>

    <?php if (empty($qr_base64)) { ?>
        <form method="POST">
            <label>Select Amount:</label>
            <select name="amount" required>
                <option value="500">₹500</option>
                <option value="1000">₹1000</option>
                <option value="1500">₹1500</option>
                <option value="2000">₹2000</option>
            </select>
            <button type="submit" style="background:#007bff;color:white;border:none;">Generate QR</button>
        </form>
    <?php } else { ?>
        <img src="data:image/png;base64,<?php echo $qr_base64; ?>" width="200" class="qr-img">
        <h4>Scan QR to Pay ₹<?php echo $_SESSION['txn_amount']; ?></h4>
        <h4>Time Left: <span id="upiTimer">2:00</span></h4>
    <?php } ?>
</div>

<?php if (!empty($qr_base64)) { ?>
<script>
    let timer = 120;
    let interval = setInterval(() => {
        let min = Math.floor(timer / 60);
        let sec = timer % 60;
        document.getElementById("upiTimer").innerText = `${min}:${sec<10?'0'+sec:sec}`;
        timer--;
        if (timer < 0) {
            clearInterval(interval);
            Swal.fire("Timeout!", "Payment time expired.", "error").then(() => {
                location.href = "";
            });
        }
    }, 1000);

    let verifyInterval = setInterval(() => {
        fetch("", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "check_status=1"
        }).then(res => res.text())
        .then(data => {
            if (data.includes("SUCCESS")) {
                clearInterval(verifyInterval);
                Swal.fire({
                    icon: 'success',
                    title: 'Payment Successful!',
                    text: 'Wallet updated. Redirecting...',
                    timer: 3000,
                    showConfirmButton: false
                }).then(() => {
                    window.location.href = "https://uiducl.org/admin/index.php";
                });
            }
        });
    }, 5000);
</script>
<?php } ?>

</body>
</html>
