const rdServiceUrl = "http://127.0.0.1:11100"; // RD Service চলমান পোর্ট

function getRDServiceInfo() {
    return fetch(`${rdServiceUrl}/rd/info`, {
        method: "RDSERVICE"
    })
    .then(response => response.text())
    .then(data => {
        console.log("RD Service Info:", data);
        return data;
    })
    .catch(error => {
        console.error("RD Service Info Error:", error);
    });
}

function captureFingerprint() {
    const pidOptions = `
        <PidOptions ver="1.0">
            <Opts env="P" fCount="1" fType="0" iCount="0" pCount="0" format="0" pidVer="2.0" timeout="10000" otp="" wadh="" posh=""/>
        </PidOptions>
    `;

    return fetch(`${rdServiceUrl}/rd/capture`, {
        method: "CAPTURE",
        headers: {
            "Content-Type": "text/xml"
        },
        body: pidOptions
    })
    .then(response => response.text())
    .then(data => {
        console.log("Capture Response:", data);
        return data;
    })
    .catch(error => {
        console.error("Capture Error:", error);
    });
}
