<?php
include('header.php');
include('../includes/config.php'); // DB connection

// Login করা user এর userid session এ আছে ধরে নিচ্ছি
$userid = $_SESSION['userid'] ?? null;  
$applyby = null;

if ($userid) {
    // usertable থেকে phone বের করা
    $q = mysqli_query($conn, "SELECT phone FROM usertable WHERE userid='$userid' LIMIT 1");
    if ($q && mysqli_num_rows($q) > 0) {
        $row = mysqli_fetch_assoc($q);
        $applyby = $row['phone'];
    }
}

// যদি form submit হয়
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name       = mysqli_real_escape_string($conn, $_POST['name'] ?? '');
    $eid        = mysqli_real_escape_string($conn, $_POST['eid'] ?? '');
    $username   = mysqli_real_escape_string($conn, $_POST['username'] ?? '');
    $request    = mysqli_real_escape_string($conn, $_POST['request'] ?? '');

    // Upload Folder
    $uploadDir = "../uploads/";
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // File Upload 1
    $pdf1 = null;
    if (!empty($_FILES['pdf1']['name'])) {
        $pdf1 = time() . "_1_" . basename($_FILES['pdf1']['name']);
        move_uploaded_file($_FILES['pdf1']['tmp_name'], $uploadDir . $pdf1);
    }

    // File Upload 2
    $pdf2 = null;
    if (!empty($_FILES['pdf2']['name'])) {
        $pdf2 = time() . "_2_" . basename($_FILES['pdf2']['name']);
        move_uploaded_file($_FILES['pdf2']['tmp_name'], $uploadDir . $pdf2);
    }

    // Insert into DB (applyby = logged-in user's phone)
    $sql = "INSERT INTO reject_1 (name, eid, pdf1, pdf2, username, request_type, applyby) 
            VALUES ('$name', '$eid', '$pdf1', '$pdf2', '$username', '$request', '$applyby')";

    if (mysqli_query($conn, $sql)) {
        echo "<script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: '✅ Form Submitted Successfully!',
                    confirmButtonText: 'OK'
                }).then(() => {
                    window.location.href='https://uiducl.org/admin/index.php';
                });
            });
        </script>";
    } else {
        echo "<script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: '❌ Database Error: " . mysqli_error($conn) . "'
                });
            });
        </script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Form Fillup</title>
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    body {background:#f5f6fa; margin:0; font-family:Arial,sans-serif;}
    .content-wrapper {display:flex; justify-content:center; align-items:center; min-height:calc(100vh - 80px);}
    .form-container {
      background:#fff; padding:25px 35px; border-radius:12px;
      box-shadow:0px 6px 16px rgba(0,0,0,0.15); width:450px;
    }
    .form-container h2 {text-align:center; margin-bottom:20px; color:#2c3e50;}
    label {font-weight:bold; display:block; margin-top:12px; margin-bottom:5px;}
    input, select {
      width:100%; padding:10px; border:1px solid #ccc; border-radius:8px; outline:none;
    }
    input:focus, select:focus {border-color:#3498db; box-shadow:0px 0px 6px rgba(52,152,219,0.3);}
    button {
      margin-top:20px; width:100%; padding:12px; background:#3498db; border:none;
      color:white; font-size:16px; font-weight:bold; border-radius:8px; cursor:pointer;
    }
    button:hover {background:#2980b9;}
  </style>
</head>
<body>

<div class="content-wrapper">
  <div class="form-container">
    <h2>Form Fillup</h2>
    <form method="POST" enctype="multipart/form-data">
      
      <label for="name">Name</label>
      <input type="text" name="name" required>

      <label for="eid">EID</label>
      <input type="text" name="eid" required>

      <label for="pdf1">Upload PDF 1</label>
      <input type="file" name="pdf1" accept="application/pdf" required>

      <label for="pdf2">Upload PDF 2</label>
      <input type="file" name="pdf2" accept="application/pdf" required>

      <label for="username">Username</label>
      <input type="text" name="username" required>

      <label for="request">Select Request</label>
      <select name="request" required>
        <option value="">-- Select --</option>
        <option value="DOB">DOB</option>
        <option value="NAME">NAME</option>
        <option value="CHILD">CHILD</option>
      </select>

      <button type="submit">Submit</button>
    </form>
  </div>
</div>

</body>
</html>
