<?php
include('header.php');
include('../includes/config.php'); // DB connection

$result = mysqli_query($conn, "SELECT * FROM reject_1 ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Reject List</title>
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    body {font-family: Arial, sans-serif; background: #f5f6fa; margin:0; padding:20px;}
    h2 {text-align:center; margin-bottom:20px; color:#2c3e50;}
    table {
      border-collapse: collapse;
      width: 100%;
      background: #fff;
      box-shadow: 0px 6px 16px rgba(0,0,0,0.1);
    }
    th, td {
      border: 1px solid #ddd;
      padding: 10px;
      text-align: center;
    }
    th {
      background: #3498db;
      color: white;
    }
    tr:nth-child(even) {background: #f9f9f9;}
    .btn {
      display: inline-block;
      padding: 6px 12px;
      background: #3498db;
      color: #fff;
      text-decoration: none;
      border-radius: 6px;
      font-size: 14px;
    }
    .btn:hover { background: #2980b9; }
    .username-box {
      background: #eaf4ff;
      border: 1px solid #3498db;
      border-radius: 6px;
      color: #0066cc;
      font-weight: bold;
      padding: 5px 10px;
      display: block;
      margin-top: 5px;
    }
    .applyby-box {
      background: #3498db;
      color: #fff;
      font-weight: bold;
      padding: 5px 10px;
      border-radius: 6px;
      display: block;
      margin-bottom: 5px;
    }
    .userinfo-cell {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 5px;
    }
  </style>
</head>
<body>

<h2>Reject Form Submissions</h2>

<table>
  <tr>
    <th>ID</th>
    <th>Apply By</th>
    <th>Name</th>
    <th>EID</th>
    <th>Username</th>
    <th>Request Type</th>
    <th>PDF 1</th>
    <th>PDF 2</th>
    <th>Submitted At</th>
  </tr>

  <?php while($row = mysqli_fetch_assoc($result)) { ?>
  <tr>
    <td><?php echo $row['id']; ?></td>
    <td class="applyby"><?php echo htmlspecialchars($row['applyby']); ?></td>
    <td><?php echo htmlspecialchars($row['name']); ?></td>
    <td><?php echo htmlspecialchars($row['eid']); ?></td>
    <td>
      <span class="username-box"><?php echo htmlspecialchars($row['username']); ?></span>
    </td>
    <td><?php echo htmlspecialchars($row['request_type']); ?></td>
    <td>
      <?php if(!empty($row['pdf1'])) { ?>
        <a class="btn" href="../uploads/<?php echo $row['pdf1']; ?>" download
           onclick="Swal.fire({icon:'success',title:'Download Started',text:'PDF1 downloading...',timer:2000,showConfirmButton:false});">
           Download PDF1</a>
      <?php } else { echo "N/A"; } ?>
    </td>
    <td>
      <?php if(!empty($row['pdf2'])) { ?>
        <a class="btn" href="../uploads/<?php echo $row['pdf2']; ?>" download
           onclick="Swal.fire({icon:'success',title:'Download Started',text:'PDF2 downloading...',timer:2000,showConfirmButton:false});">
           Download PDF2</a>
      <?php } else { echo "N/A"; } ?>
    </td>
    <td><?php echo $row['created_at']; ?></td>
  </tr>
  <?php } ?>
</table>

</body>
</html>
