<?php
session_start();
include_once 'includes/config.php'; // <-- তোমার DB config ফাইল
include_once 'includes/functions.php'; // helper functions (optional)

$mode = $_GET['mode'] ?? 'login'; // default login
$err = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['login'])) {
        // ==== LOGIN ====
        $identifier = clean($conn, $_POST['identifier']);
        $password = $_POST['password'];
        if ($identifier && $password) {
            $sql = "SELECT * FROM users WHERE userid='$identifier' OR email='$identifier' OR phone='$identifier' LIMIT 1";
            $res = mysqli_query($conn, $sql);
            if ($res && mysqli_num_rows($res) == 1) {
                $row = mysqli_fetch_assoc($res);
                if (password_verify($password, $row['password'])) {
                    $_SESSION['user_id'] = $row['id'];
                    $_SESSION['userid']  = $row['userid'];
                    $_SESSION['name']    = $row['name'];
                    $_SESSION['usertype'] = $row['usertype'];
                    header("Location: auth.php?mode=dashboard");
                    exit;
                } else $err = "Wrong password.";
            } else $err = "User not found.";
        } else $err = "All fields required.";
    }
    elseif (isset($_POST['register'])) {
        // ==== REGISTER ====
        $userid = clean($conn, $_POST['userid']);
        $name = clean($conn, $_POST['name']);
        $email = clean($conn, $_POST['email']);
        $phone = clean($conn, $_POST['phone']);
        $password = $_POST['password'];
        $cpassword = $_POST['cpassword'];

        if ($userid && $email && $password && $password === $cpassword) {
            $exists = mysqli_query($conn, "SELECT id FROM users WHERE email='$email' OR userid='$userid'");
            if (mysqli_num_rows($exists) > 0) {
                $err = "UserID or Email already exists.";
            } else {
                $hash = password_hash($password, PASSWORD_DEFAULT);
                $sql = "INSERT INTO users (userid, name, email, phone, password) 
                        VALUES ('$userid','$name','$email','$phone','$hash')";
                if (mysqli_query($conn, $sql)) $success = "Registration successful! Please login.";
                else $err = "Error: " . mysqli_error($conn);
            }
        } else $err = "Check inputs (password mismatch or empty fields).";
    }
    elseif (isset($_POST['forgot'])) {
        // ==== FORGOT PASSWORD ====
        $email = clean($conn, $_POST['email']);
        if ($email) {
            // NOTE: এখানে তুমি চাইলে reset token/email system বসাতে পারো
            $success = "Password reset instructions will be sent (demo). Contact admin.";
        } else $err = "Enter your email.";
    }
    elseif (isset($_POST['logout'])) {
        // ==== LOGOUT ====
        session_destroy();
        header("Location: auth.php");
        exit;
    }
}
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Auth System</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/@sweetalert2/theme-dark@5/dark.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body{font-family:Inter,Arial; background:linear-gradient(180deg,#0f172a,#071032); color:#eee; margin:0; min-height:100vh; display:flex; align-items:center; justify-content:center}
.card{background:rgba(255,255,255,0.05); padding:30px; border-radius:16px; width:400px; box-shadow:0 8px 30px rgba(0,0,0,0.5);}
h2{text-align:center;margin:0 0 16px}
label{display:block;margin-top:10px;font-size:13px}
input{width:100%;padding:10px;margin-top:6px;border-radius:8px;border:1px solid #333;background:#111;color:#eee}
button{margin-top:16px;width:100%;padding:12px;border:0;border-radius:10px;cursor:pointer;font-weight:600;background:linear-gradient(90deg,#06b6d4,#7c3aed);color:white}
.muted{text-align:center;margin-top:10px;font-size:13px}
a{color:#9ae6b4;text-decoration:none}
</style>
</head>
<body>
<div class="card">
<?php
// Alerts
if ($err) echo "<script>Swal.fire({icon:'error',title:'".addslashes($err)."'});</script>";
if ($success) echo "<script>Swal.fire({icon:'success',title:'".addslashes($success)."'});</script>";

if ($mode == 'login') {
?>
  <h2>Login</h2>
  <form method="post">
    <label>UserID / Email / Phone</label>
    <input name="identifier" required>
    <label>Password</label>
    <input name="password" type="password" required>
    <button name="login">Login</button>
  </form>
  <div class="muted">
    <a href="auth.php?mode=register">Create account</a> · 
    <a href="auth.php?mode=forgot">Forgot password?</a>
  </div>
<?php
} elseif ($mode == 'register') {
?>
  <h2>Register</h2>
  <form method="post">
    <label>UserID</label><input name="userid" required>
    <label>Name</label><input name="name">
    <label>Email</label><input name="email" type="email" required>
    <label>Phone</label><input name="phone">
    <label>Password</label><input name="password" type="password" required>
    <label>Confirm Password</label><input name="cpassword" type="password" required>
    <button name="register">Register</button>
  </form>
  <div class="muted"><a href="auth.php">Back to Login</a></div>
<?php
} elseif ($mode == 'forgot') {
?>
  <h2>Forgot Password</h2>
  <form method="post">
    <label>Email</label><input name="email" type="email" required>
    <button name="forgot">Reset</button>
  </form>
  <div class="muted"><a href="auth.php">Back to Login</a></div>
<?php
} elseif ($mode == 'dashboard') {
    if (!isset($_SESSION['user_id'])) {
        header("Location: auth.php");
        exit;
    }
?>
  <h2>Welcome, <?php echo htmlspecialchars($_SESSION['name'] ?: $_SESSION['userid']); ?></h2>
  <p>Usertype: <?php echo htmlspecialchars($_SESSION['usertype']); ?></p>
  <form method="post"><button name="logout">Logout</button></form>
<?php
}
?>
</div>
</body>
</html>
