<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>User Registration</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <style>
    body {
      background: linear-gradient(to right, #74ebd5, #ACB6E5);
      font-family: 'Segoe UI', sans-serif;
    }
    .register-box {
      max-width: 600px;
      margin: 40px auto;
      background: white;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 0 20px rgba(0,0,0,0.2);
    }
    h2 {
      text-align: center;
      margin-bottom: 20px;
    }
  </style>
</head>
<body>

<div class="register-box">
  <h2>User Registration</h2>
  <form action="register.php" method="POST">
    <div class="mb-3">
      <label class="form-label">Full Name</label>
      <input type="text" name="name" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Phone Number</label>
      <input type="text" name="phone" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Email</label>
      <input type="email" name="email" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Password</label>
      <input type="password" name="password" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">City</label>
      <input type="text" name="city" class="form-control">
    </div>

    <div class="mb-3">
      <label class="form-label">State</label>
      <input type="text" name="state" class="form-control">
    </div>

    <div class="mb-3">
      <label class="form-label">User Type</label>
      <select name="usertype" class="form-control" required>
        <option value="">Select</option>
        <option value="admin">Admin</option>
        <option value="user">User</option>
      </select>
    </div>

    <button type="submit" class="btn btn-primary w-100">Register</button>
  </form>
</div>

</body>
</html>
